/*
 * Prototypes, type, and definitions in FMS helper library
 */
#ifndef _libfma_h_
#define _libfma_h_

#ifndef MCP
#ifdef _WIN32
#include "lf_win.h"
#else
#include <stdint.h>
#endif
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#endif


#include "config.h"

/*
 * some constants
 */
#ifndef TRUE
#define TRUE (1==1)
#define FALSE (1==2)
#endif

#define LF_STRING_LEN 256	/* length of generic strings */
#define LF_SHORT_STRING_LEN 32	/* length of short generic strings */

#define LF_NUM_ELEM(A) (sizeof(A)/sizeof(*(A)))

#define LF_DFLT_DB_NAME "database"
#define LF_DFLT_INFO_DIR "productinfo"

#define LF_ENV_FMS_RUN "FMS_RUN"
#define LF_ENV_DB_NAME "FMS_DB_NAME"
#define LF_ENV_FMS_INSTALL "FMS_INSTALL"
#define LF_ENV_FMS_SERVER "FMS_SERVER"
#define LF_ENV_FMS_DEBUG "FMS_DEBUG"	/* env var to enable FMS debug */
#define LF_ENV_FMA_DEBUG "FMA_DEBUG"	/* env var to enable FMA debug */

#define LF_MAX_NIC_PORTS 2		/* max ports on a NIC */
#define MYRI_MAX_ROUTE_LEN 24		/* max route len */
#if (MYRI_MAX_ROUTE_LEN % 8) != 0
#error MYRI_MAX_ROUTE_LEN must be multiple of 8
#endif

/*
 * Firmware types
 */
enum lf_firmware_type {
  MYRI_FW_UNKNOWN=0,
  MYRI_FW_GM_1=1,
  MYRI_FW_GM_2=2,
  MYRI_FW_MX_1=10,
  MYRI_FW_XM_1=50,
  MYRI_FW_2Z_1=60,
  MYRI_FW_LXGDB_1=70
};

extern char *Lf_version;		/* FMS version */
extern char *Lf_dflt_fms_server;	/* default fms server */

/*
 * Library-wide types
 */
typedef unsigned char lf_mac_addr_t[6];
typedef char lf_string_t[LF_STRING_LEN];

/* standards defined length of Link Aggregation ID */
#define LF_LAG_ID_LEN 26

/*
 * prototypes
 */
void lf_init(void);
void lf_finalize(void);
void line2words(char *buf, char **wp, char *seps, int maxwc, int *wc);
void line2words_nullok(char *buf, char **wp, char *seps, int maxwc, int *wc);
void lf_trim_nl(char *s);
void lf_set_error_handler( void (*error_rtn)(char *, int, int, char *));
char **lf_dup_string_array(char **strings, int nstr);
void lf_free_string_array(char **strings, int nstr);
void lf_socket_init(void);
void lf_socket_finalize(void);
int lf_listen_on_socket(int port);
int lf_accept_connection(int s, void **who);
int lf_connect_to_host(char *hostname, int port);
int lf_read(int d, void *b, int len);
int lf_write(int d, void *b, int len);
int lf_init_product_info(char *install);
void lf_make_mac_hostname(char *hostname, lf_mac_addr_t mac_addr, int np);
char * lf_error_msg_fmt (const char *fmt, ...);
void lf_error_msg_free (char * p);
char *lf_timestamp(void);
char *lf_error_msg_fmt(const char *fmt, ...);
void lf_error_msg_free(char * p);

/*
 * utiilty macros
 */
#define LF_MAC_COPY(D, S) memcpy((D),(S),sizeof(lf_mac_addr_t))
#define LF_MAC_CMP(D, S) memcmp((D),(S),sizeof(lf_mac_addr_t))
#define LF_MAC_FORMAT "%02x:%02x:%02x:%02x:%02x:%02x"
#define LF_MAC_ARGS(M)							\
  (unsigned int)((M)[0]), (unsigned int)((M)[1]), (unsigned int)((M)[2]),\
  (unsigned int)((M)[3]), (unsigned int)((M)[4]), (unsigned int)((M)[5])
#define LF_FREE(P) do { if ((P)!=NULL) {free(P); (P)=NULL; } } while (0)
#define LF_STRCPY(D, S) strncpy((D), (S), LF_STRING_LEN-1)

/* this always swaps */
static inline uint32_t
lf_swap_l(
  uint32_t v)
{
  return ((v >> 24) & 0xff) | ((v >> 8) & 0xff00)
          | ((v << 8) & 0xff0000) | ((v << 24) & 0xff000000);
}



/* it is up to the user to define "LF_ERROR" */

#define LF_DUP_STRING(DST, SRC)						\
  do {									\
    LF_FREE(DST);							\
    if ((SRC) != NULL) {						\
      (DST) = malloc(strlen(SRC)+1);					\
      if ((DST) == NULL) {						\
	LF_ERROR(("duplicating string"));				\
      }									\
      strcpy((DST),(SRC));						\
    }									\
  } while (0)

#define LF_CALLOC(PTR, TYPE, NUM)					\
  do {									\
    if ((NUM)*sizeof(TYPE) > 0) {					\
      (PTR) = (TYPE *) calloc((NUM), sizeof(TYPE));			\
      if ((PTR) == NULL) {						\
        LF_ERROR(("allocating memory"));				\
      }									\
    } else {								\
      (PTR) = NULL;							\
    }									\
  } while (0)

#define LF_CALLOC_C(PTR, CAST, TYPE, NUM)				\
  do {									\
    if ((NUM)*sizeof(TYPE) > 0) {					\
      (PTR) = (CAST) calloc((NUM), sizeof(TYPE));			\
      if ((PTR) == NULL) {						\
	LF_ERROR(("allocating memory"));				\
      }									\
    } else {								\
      (PTR) = NULL;							\
    }									\
  } while (0)

#define LF_MALLOC(PTR, CAST, SIZE)					\
  do {									\
    (PTR) = (CAST) malloc(SIZE);					\
    if ((PTR) == NULL) {						\
      LF_ERROR(("allocating memory"));					\
    }									\
  } while (0)

#endif /* _libfma_h_ */
